library(arules)
library(arulesViz)
# 1.1
#Step 1. Prepare the data
dat0=read.csv("data/DVD.csv")
dat=split(x=as.factor(dat0[,"Items"]),f=as.factor(dat0[,"Users"]))
dat=as(dat,c("itemMatrix","transactions")[1])
dev.new();image(dat,main=paste0(dim(dat)[1]," Users/", dim(dat)[2]," Items")) #Fig 1.1-2

item.matrix=matrix(as.numeric(as.vector(dat@data)),dim(dat),byrow = TRUE)
colnames(item.matrix)=names(itemFrequency(dat))
item.matrix

dev.new();itemFrequencyPlot(dat,horiz=TRUE);grid()#Fig 1.1-4
dev.new();itemFrequencyPlot(dat,horiz=TRUE,support=0.1);grid()#Fig 1.1-5

dev.new();lattice::barchart(sort(itemFrequency(dat)),xlab="Frequency") #Fig 1.1-6

library(ggplot2)
gg.dat=data.frame(name=names(itemFrequency(dat)),
               value=as.numeric(itemFrequency(dat)))
dev.new();ggplot(gg.dat, aes(x=name, y=value)) + 
  geom_bar(stat = "identity") +
  coord_flip() #Fig 1.1-7

#####################
# 1.2

## Step 2. Mining rules

### Method 1. apriori 
DVD0=apriori(dat, parameter=list(support=0.1,confidence=0.1,maxlen=5))
inspect(DVD0)
summary(DVD0)
DVD0@lhs@data@Dim[2]

dev.new();plot(DVD0,
               measure=c("confidence","lift"),
               shading="support",
               control=list(jitter=6)) #fig. 1.2-4

dev.new();plot(DVD0,measure=c("confidence","lift"),shading="order",control=list(jitter=6))
dev.new();plot(DVD0,
               method="grouped") #sum(itemFrequency(dat)>0.1) #1.2-5

DVD=DVD0[-seq(8),]
dev.new();plot(DVD,
               method="grouped") #sum(itemFrequency(dat)>0.1) #1.2-6

#dev.new();plot(DVD,method="grouped", engine = "interactive")
dev.new();plot(DVD,method="graph") #1.2-7


DVDx <- subset(DVD,subset= rhs %in% "Patriot" & lift>1)
inspect(DVDx)

inspect((sort(DVD,by="support")))[,-6]
dev.new();plot(DVDx,method="grouped")


round(t(interestMeasure(DVD)),2)
names(interestMeasure(DVD))
interestMeasure(DVD, c("support","confidence", "lift"))

inspect((apriori(dat, parameter=list(support=0.1,confidence=0.1,maxlen=5))))

### Method 2. FP-Growth
fpG=fim4r(dat, method = "fpgrowth", target = "rules", supp = .1, conf = .1)

inspect(sort(fpG,by="lift"))

### Method 3. eclat:Equivalence Class Clustering and bottom-up Lattice Traversal.

newdata1=as(dat,c("itemMatrix","transactions")[2])
itemsets <- eclat(newdata1,parameter = list(supp = 0.1))
itemsets
inspect(itemsets)
supportingTransactions(itemsets, newdata1)

#### Create rules from the frequent itemsets
rules <- ruleInduction(itemsets, confidence = 0.1)
rules
inspect(rules)


#### Mine frequent itemsets with Eclat.
fsets <- eclat(newdata1, parameter = list(supp = 0.1))
fsets.top5 <- sort(fsets)[1:5]
inspect(fsets.top5)

as(items(fsets.top5), "list")
as(items(fsets.top5), "matrix")


Adult
data(Income)
## Homework: 

#1. Using package dataset "Income", and check package PDF manual for details,
#and explain the code via markdown.


